;;; - ------------------------------------------------------------------------------ - ;
;;; -                 T O O L - K_RP-DRAW                                            - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung :  Raumpolygone und Umgrenzungen ber zusammengesetzte Rechtecke  - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Befehle      :  k_rp-draw                                                      - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 03.08.2023                                                - ;
;;; -              durch : Andreas Kraus                                             - ;
;;; - ------------------------------------------------------------------------------ - ;

(vl-load-com)
(DEFUN I-CDR (LST) (REVERSE (CDR (REVERSE LST))))
(DEFUN K_->ENT_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME)) NAME)
	((= (TYPE NAME) (QUOTE VLA-OBJECT))
	 (vlax-vla-object->ename NAME)
	)
	((= (TYPE NAME) (QUOTE STR)) (HANDENT NAME))
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (CDR (ASSOC -1 NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (HANDENT (CDR (ASSOC 5 NAME)))
	)
  )
)
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC -1 NAME))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
	((AND (= (TYPE NAME) (QUOTE LIST)) (ASSOC 5 NAME))
	 (vlax-ename->vla-object (HANDENT (CDR (ASSOC 5 NAME))))
	)
  )
)
(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)
(DEFUN K_ACBC (DUMMY1 DUMMY2)
  (IF (VL-STRING-SEARCH "BricsCAD" (GETVAR "acadver"))
    DUMMY1
    DUMMY2
  )
)
(DEFUN K_BIT (WERT BIT) (= (LOGAND WERT BIT) BIT))
(DEFUN K_ELLIPSE->PLINE	(OBJ_NAME BREITE / D L N OBJ_LIST OBJ_NAME P P1	P2 P3 PREC P_LIST Q Z)
  (SETQ	PREC	 64
	OBJ_NAME (K_->OBJ_NAME OBJ_NAME)
	L	 (IF (K_IS-CLOSED OBJ_NAME)
		   (* (vlax-curve-getDistAtPoint
			OBJ_NAME
			(vlax-curve-getPointAtParam OBJ_NAME PI)
		      )
		      2.0
		   )
		   (vlax-curve-getDistAtPoint
		     OBJ_NAME
		     (vlax-curve-getEndPoint OBJ_NAME)
		   )
		 )
	N	 (* PREC
		    (/ (ABS (- (vlax-curve-getEndParam OBJ_NAME)
			       (vlax-curve-getStartParam OBJ_NAME)
			    )
		       )
		       (* PI 2.0)
		    )
		 )
  )
  (IF (NOT (EQUAL (REM N 1) 0))
    (SETQ N (1+ (FIX N)))
  )
  (SETQ	P_LIST (MAPCAR (QUOTE (LAMBDA (P) (TRANS P 0 1)))
		       (MAPCAR (QUOTE (LAMBDA (D) (vlax-curve-getPointAtDist OBJ_NAME D)))
			       (K_ZAHLENREIHE_START_STEP N 0 (/ L N))
		       )
	       )
  )
  (SETQ	P_LIST	 (MAPCAR (QUOTE	(LAMBDA	(P)
				  (MAPCAR (QUOTE (LAMBDA (Q) (ROUND Q 1.0e-08))) P)
				)
			 )
			 P_LIST
		 )
	OBJ_LIST (MAPCAR (QUOTE
			   (LAMBDA (P1 P3 / P2 Z)
			     (SETQ P2 (TRANS (vlax-curve-getPointAtParam
					       OBJ_NAME
					       (/ (+ (vlax-curve-getParamAtPoint OBJ_NAME (TRANS P1 1 0))
						     (IF (EQUAL	(vlax-curve-getParamAtPoint OBJ_NAME (TRANS P3 1 0))
								0
							 )
						       (* PI 2.0)
						       (vlax-curve-getParamAtPoint OBJ_NAME (TRANS P3 1 0))
						     )
						  )
						  2.0
					       )
					     )
					     0
					     1
				      )
			     )
			     (SETQ Z (INTERS (K_MIDP P1 P2)
					     (POLAR (K_MIDP P1 P2) (+ (ANGLE P1 P2) (* PI 0.5)) 1)
					     (K_MIDP P2 P3)
					     (POLAR (K_MIDP P2 P3) (+ (ANGLE P2 P3) (* PI 0.5)) 1)
					     nil
				     )
			     )
			     (vla-AddArc
			       (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
			       (vlax-3d-point (TRANS Z 1 0))
			       (DISTANCE Z P1)
			       (ANGLE Z P1)
			       (ANGLE Z P3)
			     )
			   )
			 )
			 (I-CDR P_LIST)
			 (CDR P_LIST)
		 )
  )
  (vla-Delete OBJ_NAME)
  (CAR (K_SATZ->OBJLIST (P001 OBJ_LIST BREITE)))
)
(DEFUN K_ENTLIST->SATZ (ENT_LIST / N SATZ ENT_NAME)
  (IF (LISTP ENT_LIST)
    (PROGN (SETQ SATZ (SSADD))
	   (MAPCAR (QUOTE
		     (LAMBDA (ENT_NAME)
		       (COND ((= (TYPE ENT_NAME) (QUOTE VLA-OBJECT))
			      (SETQ SATZ (SSADD (vlax-vla-object->ename ENT_NAME) SATZ))
			     )
			     ((= (TYPE ENT_NAME) (QUOTE ENAME))
			      (SETQ SATZ (SSADD ENT_NAME SATZ))
			     )
			     ((= (TYPE ENT_NAME) (QUOTE STR))
			      (IF (HANDENT ENT_NAME)
				(SETQ SATZ (SSADD (HANDENT ENT_NAME) SATZ))
			      )
			     )
		       )
		     )
		   )
		   ENT_LIST
	   )
    )
  )
  SATZ
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_IS (WERT)
  (COND	((= WERT :vlax-false) nil)
	((= WERT :vlax-true) T)
	((= WERT nil) nil)
	((= WERT T) T)
	((= WERT 1) T)
	((= WERT 0) nil)
	((= WERT "1") T)
	((= WERT "0") nil)
	((= (STRCASE WERT) "JA") T)
	((= (STRCASE WERT) "NEIN") nil)
  )
)
(DEFUN K_IS-CLOSED (OBJ_NAME)
  (SETQ OBJ_NAME (K_->OBJ_NAME OBJ_NAME))
  (COND	((MEMBER (vla-get-ObjectName OBJ_NAME)
		 (QUOTE ("AcDbPolyline" "AcDb3dPolyline" "AcDbSpline"))
	 )
	 (K_IS (vla-get-Closed OBJ_NAME))
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbMline")
	 (K_BIT (CDR (ASSOC 71 ENT_DATA)) 2)
	)
	((= (vla-get-ObjectName OBJ_NAME) "AcDbEllipse")
	 (AND (/= (vla-get-StartAngle OBJ_NAME)
		  (vla-get-EndAngle OBJ_NAME)
	      )
	      (EQUAL (POLAR (QUOTE (0.0 0.0 0.0))
			    (vla-get-StartAngle OBJ_NAME)
			    1.0
		     )
		     (POLAR (QUOTE (0.0 0.0 0.0))
			    (vla-get-EndAngle OBJ_NAME)
			    1.0
		     )
		     1.0e-08
	      )
	 )
	)
  )
)
(DEFUN K_MIDP (P1 P2)
  (SETQ MIDP (MAPCAR (QUOTE (LAMBDA (X1 X2) (/ (+ X1 X2) 2))) P1 P2))
)
(DEFUN K_OBJLIST->SATZ (OBJ_LIST)
  (K_ENTLIST->SATZ
    (MAPCAR (QUOTE vlax-vla-object->ename) OBJ_LIST)
  )
)
(DEFUN K_PURGE_LIST (LISTE / DUMMY_LIST)
  (WHILE LISTE
    (SETQ DUMMY_LIST (CONS (CAR LISTE) DUMMY_LIST)
	  LISTE	     (VL-REMOVE (CAR LISTE) LISTE)
    )
  )
  (REVERSE DUMMY_LIST)
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN K_RESTORE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= VARLIST "*")
    (SETQ VARLIST (MAPCAR (QUOTE (LAMBDA (VAR) (NTH 0 VAR))) K_SAVEVAR_LIST))
  )
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(SETQ VAR (ASSOC VAR K_SAVEVAR_LIST))
      (SETVAR (NTH 0 VAR) (NTH 1 VAR))
    )
  )
)
(DEFUN K_SATZ->ENTLIST (SATZ)
  (IF (= (TYPE SATZ) (QUOTE PICKSET))
    (VL-REMOVE-IF-NOT
      (QUOTE (LAMBDA (DUMMY) (= (TYPE DUMMY) (QUOTE ENAME))))
      (MAPCAR (QUOTE CADR) (SSNAMEX SATZ))
    )
  )
)
(DEFUN K_SATZ->OBJLIST (SATZ)
  (MAPCAR (QUOTE vlax-ename->vla-object)
	  (K_SATZ->ENTLIST SATZ)
  )
)
(DEFUN K_SAVE_VAR (VARLIST / K_SAVEVAR_LIST)
  (SETQ K_SAVEVAR_LIST (K_GET_MERKLISTE "k_savevar_list"))
  (IF (= (TYPE VARLIST) (QUOTE STR))
    (SETQ VARLIST (LIST VARLIST))
  )
  (FOREACH VAR VARLIST
    (IF	(ASSOC VAR K_SAVEVAR_LIST)
      (SETQ K_SAVEVAR_LIST
	     (SUBST (LIST VAR (GETVAR VAR))
		    (ASSOC VAR K_SAVEVAR_LIST)
		    K_SAVEVAR_LIST
	     )
      )
      (SETQ K_SAVEVAR_LIST (CONS (LIST VAR (GETVAR VAR)) K_SAVEVAR_LIST))
    )
  )
  (K_PUT_MERKLISTE "k_savevar_list" K_SAVEVAR_LIST)
)
(DEFUN K_VARIANT->VALUE	(VAR / VALUE)
  (IF (= (TYPE VAR) (QUOTE variant))
    (PROGN (SETQ VALUE (vlax-variant-value VAR))
	   (COND ((= (TYPE VALUE) (QUOTE safearray))
		  (IF (MINUSP (vlax-safearray-get-u-bound VALUE 1))
		    nil
		    (vlax-safearray->list VALUE)
		  )
		 )
		 (T VALUE)
	   )
    )
    VAR
  )
)
(DEFUN K_ZAHLENREIHE (Z / N REIHE)
  (SETQ REIHE (LIST Z))
  (REPEAT (FIX Z) (SETQ REIHE (CONS (1- (CAR REIHE)) REIHE)))
  REIHE
)
(DEFUN K_ZAHLENREIHE_START (Z START)
  (MAPCAR (QUOTE (LAMBDA (N) (+ START N))) (K_ZAHLENREIHE Z))
)
(DEFUN K_ZAHLENREIHE_START_STEP	(Z START STEP)
  (MAPCAR (QUOTE (LAMBDA (N) (+ START (* STEP N))))
	  (K_ZAHLENREIHE_START Z 0)
  )
)
(DEFUN P001 (SATZ BREITE / PLINE_SATZ ANZAHL N RCKGABE	ENT_NAME NEW_ARC OBJ)
  (IF (COND ((= (TYPE SATZ) (QUOTE PICKSET)) SATZ)
	    ((= (TYPE SATZ) (QUOTE LIST))
	     (SETQ SATZ (K_ENTLIST->SATZ SATZ))
	    )
	    ((= (TYPE SATZ) (QUOTE ENAME))
	     (SETQ SATZ (K_ENTLIST->SATZ (LIST SATZ)))
	    )
	    ((= (TYPE SATZ) (QUOTE VLA-OBJECT))
	     (SETQ SATZ (K_ENTLIST->SATZ (LIST SATZ)))
	    )
	    (T nil)
      )
    (PROGN (SETQ PLINE_SATZ (SSADD))
	   (FOREACH ENT_NAME (K_SATZ->ENTLIST SATZ)
	     (COND ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "LWPOLYLINE")
		    (SETQ PLINE_SATZ (SSADD ENT_NAME PLINE_SATZ))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "SPLINE")
		    (K_SAVE_VAR "DELOBJ")
		    (SETVAR "DELOBJ" (K_ACBC 3 2))
		    (COMMAND "_.SPLINEDIT" ENT_NAME "_p" "")
		    (K_RESTORE_VAR "DELOBJ")
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "ELLIPSE")
		    (SETQ PLINE_SATZ
			   (SSADD (K_->ENT_NAME (K_ELLIPSE->PLINE ENT_NAME BREITE))
				  PLINE_SATZ
			   )
		    )
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "REGION")
		    (P001 (K_VARIANT->VALUE (vla-Explode (K_->OBJ_NAME ENT_NAME)))
			  BREITE
		    )
		    (vla-Delete (K_->OBJ_NAME ENT_NAME))
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "HATCH")
		    (COMMAND "_.explode" ENT_NAME)
		    (P001 (K_SATZ->OBJLIST (SSGET "_p")) BREITE)
		   )
		   ((= (CDR (ASSOC 0 (ENTGET ENT_NAME))) "CIRCLE")
		    (SETQ OBJ (K_->OBJ_NAME ENT_NAME))
		    (SETQ NEW_ARC (vla-AddArc
				    (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
				    (vla-get-Center OBJ)
				    (vla-get-Radius OBJ)
				    0
				    PI
				  )
		    )
		    (COMMAND "_.pedit"
			     (K_->ENT_NAME NEW_ARC)
			     "_y"
			     "_w"
			     BREITE
			     "x"
		    )
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		    (SETQ NEW_ARC (vla-AddArc
				    (vla-get-Block (vla-get-ActiveLayout (K_AC-DOC)))
				    (vla-get-Center OBJ)
				    (vla-get-Radius OBJ)
				    PI
				    (* PI 2.0)
				  )
		    )
		    (COMMAND "_.pedit"
			     (K_->ENT_NAME NEW_ARC)
			     "_y"
			     "_w"
			     BREITE
			     "x"
		    )
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		    (vla-Delete OBJ)
		   )
		   (T
		    (COMMAND "_.pedit" ENT_NAME "_y" "_w" BREITE "x")
		    (SETQ PLINE_SATZ (SSADD (ENTLAST) PLINE_SATZ))
		   )
	     )
	   )
	   (SETQ PLINE_SATZ
		  (K_OBJLIST->SATZ
		    (VL-REMOVE-IF
		      (QUOTE (LAMBDA (OBJ) (K_IS (vla-get-Closed OBJ))))
		      (K_SATZ->OBJLIST PLINE_SATZ)
		    )
		  )
	   )
	   (SETQ ANZAHL (SSLENGTH PLINE_SATZ))
	   (SETQ N 0)
	   (REPEAT ANZAHL
	     (IF PLINE_SATZ
	       (PROGN (SETQ ENT_NAME (SSNAME PLINE_SATZ N))
		      (COMMAND "_.pedit" ENT_NAME "_j" PLINE_SATZ "")
		      (WHILE (/= (GETVAR "cmdactive") 0) (COMMAND "x"))
		      (SETQ RCKGABE (CONS ENT_NAME RCKGABE))
		      (SETQ PLINE_SATZ (SSGET "_p"))
		      (IF PLINE_SATZ
			(IF (= ANZAHL (SSLENGTH PLINE_SATZ))
			  (SETQ N (1+ N))
			  (SETQ N 0)
			)
		      )
	       )
	     )
	   )
    )
  )
  (SETVAR "cmdecho" 0)
  (K_ENTLIST->SATZ RCKGABE)
)
(DEFUN ROUND (NUM PREC)
  (IF (ZEROP PREC)
    NUM
    (IF	(MEMBER (TYPE NUM) (QUOTE (INT REAL)))
      (* PREC
	 (FIX (IF (MINUSP NUM)
		(- (/ NUM PREC) 0.5)
		(+ (/ NUM PREC) 0.5)
	      )
	 )
      )
      NUM
    )
  )
)

(defun c:k_rp-draw (/ *ERROR* ENT_LIST ENT_NAME	fertig_list region_list	obj_list p1 p2)
;;; Bereiche aus fortlaufenden Rechtecken

  (defun *error* (fc)
    (setq *error* nil)
    (vla-endundomark (k_ac-doc))
    (command "_.undo" "1")
  )

  (k_save_var '("cmdecho" ""))
  (setvar "cmdecho" 0)
  (setvar "nomutt" 1)
  (vla-startundomark (k_ac-doc))

  (setq	ent_list nil
	p1 (getpoint)
  )
  (while (setq p2 (getpoint p1))
    (command "_rectang" p1 p2)
    (if	(equal (vla-get-area (k_->obj_name (entlast))) 0)
      (entdel (entlast))
      (progn
	(setq ent_list (cons (entlast) ent_list)
	      ent_list (append ent_list
			       (k_satz->entlist
				 (ssget	"_c"
					p1
					p2
					(list '(0 . "LWPOLYLINE") (cons 8 (getvar "clayer")))
				 )
			       )
		       )
	)
      )
    )
    (setq p1 p2)
  )
  (setq ent_list (k_purge_list ent_list))
  (foreach ent_name ent_list
    (vla-put-Elevation (k_->obj_name ent_name) 0.0)
    (vla-put-closed (k_->obj_name ent_name) :vlax-true)
    (command "_.region" ent_name "")
    (setq ent_list (cons (entlast) ent_list))
  )
  (command "_union" (k_entlist->satz ent_list) "")
  (setq region_list (list (k_->obj_name (entlast))))
  (while region_list
    (setq obj_list (apply 'append
			  (mapcar 'k_variant->value
				  (mapcar 'vla-explode region_list)
			  )
		   )
    )
    (mapcar 'vla-delete region_list)
    (setq region_list
		      (vl-remove-if-not
			'(lambda (obj)
			   (= (vla-get-objectname obj) "AcDbRegion")
			 )
			obj_list
		      )
	  fertig_list
		      (append fertig_list
			      (vl-remove-if
				'(lambda (obj)
				   (= (vla-get-objectname obj) "AcDbRegion")
				 )
				obj_list
			      )
		      )
    )
  )
  (p001 (k_entlist->satz fertig_list) 0)
  (k_restore_var '("cmdecho" "nomutt"))
  (vla-endundomark (k_ac-doc))
  (princ)
)
;;; - ------------------------------------------------------------------------------ - ;
(princ
  (strcat
    "\nk_rp-draw:  Raumpolygone und Umgrenzungen ber zusammengesetzte Rechtecke"
    "\n===========  "
    "\n(C) Andreas Kraus 2023 (info@kraus-cad.de)"
    "\nBefehlszeilenaufruf : k_rp-draw\n"
  )
)
;;; - ------------------------------------------------------------------------------ - ;
(princ)